/*************************************************************************
  dos2win     Translates characters between DOS and Windows formats

  Author:     SemWare

  Date:       Feb  8, 1999 - Initial version

              Mar 18, 1999 - Cleanup for shipping

  Overview:

  If the cursor is within a block, the block is translated, otherwise,
  the entire file is translated.

  Windows and DOS use different character sets.  While characters in
  the range of ASCII 32..126 are the same, those outside of that range
  are generally different.  This macro can be used to translate a
  block or a file from the DOS (OEM in Windows terminology) to the
  Windows (ANSI in Windows terminology), or to go the other way, from
  Windows to DOS.  Note that there is not a one-to-one correspondence
  between the character sets. Given that, one may not end up with what
  one started with by running both translations.

  A menu is presented to determine which translation will take place.

  Copyright 1999 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration is
  received for distribution.  You may add your own copyright notice to cover
  new matter you add to the macro, but SemWare Corporation will neither
  support nor assume legal responsibility for any material added or any
  changes made to the macro.

*************************************************************************/
dll "<user32.dll>"

integer proc OemToCharBuff(
    var string lpszSrc:strptr,	// pointer to string to translate
    var string lpszDst:strptr,	// pointer to buffer for translated string
    integer cchDstLength 	        // size of buffer
   ) : "OemToCharBuffA"

integer proc CharToOemBuff(
    var string lpszSrc:strptr,	// pointer to string to translate
    var string lpszDst:strptr,	// pointer to buffer for translated string
    integer cchDstLength 	// size of buffer
   ) : "CharToOemBuffA"

end

string proc lOemToChar(string src)
    string dst[MAXSTRINGLEN] = src

    OemToCharBuff(src, dst, Length(src))
    return (dst)
end

string proc lCharToOem(string src)
    string dst[MAXSTRINGLEN] = src

    CharToOemBuff(src, dst, Length(src))
    return (dst)
end


/**************************************************************************
  Convert a block or file from OEM to ANSI
 **************************************************************************/
proc Translate(integer oem_to_char)
    integer save_clip, start_buf, linelen, len, ilba, save_col

    save_clip = 0
    save_col = CurrCol()

    if isCursorInBlock()
        PushBlock()
        PushPosition()
        GotoBlockBegin()

        PushPosition()
        save_clip = Set(ClipBoardId, CreateTempBuffer())
        PopPosition()

        Cut()
        start_buf = GotoBufferId(Query(ClipBoardId))
    endif

    PushPosition()
    BegFile()
    repeat
        linelen = CurrLineLen()
        BegLine()
        repeat
            len = Min(linelen, MAXSTRINGLEN)
            if oem_to_char
                InsertText(lOemToChar(GetText(CurrPos(), len)), _OVERWRITE_)
            else
                InsertText(lCharToOem(GetText(CurrPos(), len)), _OVERWRITE_)
            endif
            linelen = linelen - len
        until linelen == 0
    until not Down()
    PopPosition()

    if save_clip
        GotoBufferId(start_buf)

        ilba = Set(InsertLineBlocksAbove, ON)
        Paste()
        Set(InsertLineBlocksAbove, ilba)

        PopPosition()
        GotoColumn(save_col)
        PopBlock()

        AbandonFile(Query(ClipBoardId))
        Set(ClipBoardId, save_clip)
    endif
end

menu TranslateMenu()
    "&Windows to DOS (ANSI to OEM)",     Translate(FALSE),, "Translate from the Windows chararacter set to the DOS character set"
    "&DOS to Windows (OEM to ANSI)",     Translate(TRUE),,  "Translate from the DOS chararacter set to the Windows character set"
    "&Cancel"
end

proc main()
    TranslateMenu()
end
