/****************************************************************************
  Routine to center a line.
  If a block is marked, all the lines in the block are centered, using
    the left and right margins;
  if the block is a column block, only the text in the column block is
    centered, without disturbing surrounding text.
 ***************************************************************************/
proc main()
    integer right_margin = Query(RightMargin),
        left_margin = Query(LeftMargin),
        first_line, last_line, type, p, center, cid, tid, cp

    cp = CurrPos()
    PushPosition()
    PushBlock()
    if left_margin == 0 or left_margin >= right_margin
        left_margin = 1
    endif
    first_line = CurrLine()
    last_line = first_line
    type = isCursorInBlock()
    if type
        Set(Marking, off)
        first_line = Query(BlockBegLine)
        last_line = Query(BlockEndLine)
        if type == _COLUMN_
            GotoBlockBegin()
            cid = GetBufferId()
            tid = CreateTempBuffer()
            CopyBlock()

            /*
              Need to make sure we overlay everything with spaces
             */
            PushBlock()
            GotoBufferId(cid)
            CopyBlock(_OVERWRITE_)
            FillBlock(' ')
            GotoBufferid(tid)
            PopBlock()

            last_line = last_line - first_line + 1
            first_line = 1
            left_margin = 1
            right_margin = Query(BlockEndCol) - Query(BlockBegCol) + 1
        endif
    else
        UnmarkBlock()
    endif
    if right_margin > left_margin
        GotoLine(first_line)
        repeat
            p = PosFirstNonWhite()
            center = ((p + PosLastNonWhite()) / 2) - ((left_margin + right_margin) / 2)
            ShiftText(iif(center > 0,
                - (iif(center < p, center, p - 1)), Abs(center)))
        until (not RollDown()) or CurrLine() > last_line
        if type == _COLUMN_
            GotoBufferId(cid)
            CopyBlock(_OVERWRITE_)
            AbandonFile(tid)
        endif
    endif
    PopBlock()
    PopPosition()
    GotoPos(cp)
end

